<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <title><?php echo $__env->yieldContent('title'); ?> - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #800020;      /* Maroon */
            --primary-light: #a31545;      /* Lighter Maroon */
            --primary-dark: #5c0018;       /* Darker Maroon */
            --accent-color: #FFD700;       /* Gold */
            --accent-light: #FFE55C;       /* Light Gold */
        }

        body { 
            background-color: #fff5f5; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .navbar-custom {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-light));
            padding: 1rem;
            margin-bottom: 2rem;
        }

        .navbar-nav {
            margin: 0 auto;
            display: inline-flex;
            gap: 2rem;
        }

        .navbar-custom .nav-link {
            color: white !important;
            font-weight: 500;
            padding: 0.8rem 2.5rem;
            border-radius: 8px;
            transition: all 0.3s;
            min-width: 160px;
            text-align: center;
        }

        .navbar-custom .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        .navbar-custom .nav-link.active {
            background: var(--accent-color);
            color: var(--primary-dark) !important;
            font-weight: bold;
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background: var(--primary-color) !important;
            color: white !important;
            border-radius: 15px 15px 0 0 !important;
            padding: 1rem 1.5rem;
        }

        .btn-primary {
            background: var(--primary-color);
            border-color: var(--primary-color);
        }

        .btn-primary:hover {
            background: var(--primary-light);
            border-color: var(--primary-light);
        }

        .text-primary {
            color: var(--primary-color) !important;
        }

        .profile-dropdown {
            position: relative;
            cursor: pointer;
        }

        .profile-image {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            border: 2px solid var(--accent-color);
            cursor: pointer;
            transition: all 0.3s;
            object-fit: cover;
        }

        .profile-image:hover {
            transform: scale(1.1);
        }

        .profile-menu {
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            min-width: 200px;
            display: none;
            z-index: 1000;
        }

        .profile-menu.show {
            display: block;
        }

        .profile-menu a, 
        .profile-menu button {
            display: block;
            padding: 0.8rem 1rem;
            color: var(--primary-dark);
            text-decoration: none;
            transition: all 0.3s;
            width: 100%;
            text-align: left;
            border: none;
            background: none;
        }

        .profile-menu a:hover,
        .profile-menu button:hover {
            background: rgba(128, 0, 32, 0.05);
        }

        .table th {
            background: var(--primary-color);
            color: white;
        }

        .badge {
            padding: 0.5em 1em;
        }

        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255,255,255,0.8);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<body>
    <?php $storage = app('Illuminate\Support\Facades\Storage'); ?>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container">
            <div class="navbar-nav me-auto">
                <a class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.mobil') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.mobil')); ?>">
                    <i class="fas fa-car"></i> Daftar Mobil
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.riwayat') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.riwayat')); ?>">
                    <i class="fas fa-history"></i> Riwayat
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.servis.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.servis.index')); ?>">
                    <i class="fas fa-tools"></i> Servis
                </a>
            </div>
            <div class="profile-dropdown">
                <?php if(auth()->guard()->check()): ?>
                    <?php if(Auth::user()->photo): ?>
                        <img src="<?php echo e(asset('admin/'.Auth::user()->photo)); ?>" 
                             alt="Admin" 
                             class="profile-image"
                             style="width: 45px; height: 45px; object-fit: cover;">
                    <?php else: ?>
                        <img src="<?php echo e(asset('images/default-avatar.png')); ?>" 
                             alt="Default" 
                             class="profile-image"
                             style="width: 45px; height: 45px; object-fit: cover;">
                    <?php endif; ?>
                    <div class="profile-menu">
                        <a href="<?php echo e(route('admin.profile')); ?>">
                            <i class="fas fa-user me-2"></i> Edit Profile
                        </a>
                        <hr class="my-2">
                        <form action="<?php echo e(route('admin.logout')); ?>" method="POST" class="m-0">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="dropdown-item w-100 text-start">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </button>
                        </form>
                    </div>
                <?php else: ?>
                    <img src="<?php echo e(asset('images/default-avatar.png')); ?>" 
                         alt="Default" 
                         class="profile-image"
                         style="width: 45px; height: 45px; object-fit: cover;">
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Content -->
    <div class="container">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <!-- Di bagian bawah body, tambahkan div loading -->
    <div id="loadingOverlay" class="loading-overlay" style="display:none;">
        <div class="loading-spinner"></div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Toggle profile menu
        document.querySelector('.profile-dropdown').addEventListener('click', function() {
            this.querySelector('.profile-menu').classList.toggle('show');
        });

        // Close profile menu when clicking outside
        document.addEventListener('click', function(e) {
            if (!e.target.closest('.profile-dropdown')) {
                document.querySelector('.profile-menu').classList.remove('show');
            }
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html> <?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>