<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Notifikasi -->
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <!-- Statistik Cards -->
    <div class="row mb-4">
        <!-- Total Mobil Card -->
        <div class="col-md-3 mb-3">
            <div class="card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-circle bg-primary bg-opacity-10 p-3 me-3">
                        <i class="fas fa-car fa-2x text-primary"></i>
                    </div>
                    <div>
                        <h6 class="text-muted mb-1">Total Mobil</h6>
                        <h2 class="mb-0"><?php echo e($daftarMobil->count()); ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sedang Dipinjam Card -->
        <div class="col-md-3 mb-3">
            <div class="card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-circle bg-warning bg-opacity-10 p-3 me-3">
                        <i class="fas fa-clock fa-2x text-warning"></i>
                    </div>
                    <div>
                        <h6 class="text-muted mb-1">Sedang Dipinjam</h6>
                        <h2 class="mb-0"><?php echo e($peminjaman_aktif->count()); ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sedang Diservis Card -->
        <div class="col-md-3 mb-3">
            <div class="card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-circle bg-info bg-opacity-10 p-3 me-3">
                        <i class="fas fa-tools fa-2x text-info"></i>
                    </div>
                    <div>
                        <h6 class="text-muted mb-1">Sedang Diservis</h6>
                        <h2 class="mb-0"><?php echo e($mobilDiservis); ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tersedia Card -->
        <div class="col-md-3 mb-3">
            <div class="card h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-circle bg-success bg-opacity-10 p-3 me-3">
                        <i class="fas fa-check-circle fa-2x text-success"></i>
                    </div>
                    <div>
                        <h6 class="text-muted mb-1">Tersedia</h6>
                        <h2 class="mb-0"><?php echo e($daftarMobil->where('status', 'tersedia')->count()); ?></h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tambahkan QR Code Card -->
    <div class="card shadow mb-4">
        <div class="card-body d-flex justify-content-between align-items-center">
            <div class="d-flex align-items-center">
                <div class="rounded-circle bg-primary bg-opacity-10 p-3 me-3">
                    <i class="fas fa-qrcode fa-2x text-primary"></i>
                </div>
                <div>
                    <h6 class="text-muted mb-1">QR Code Peminjaman</h6>
                    <p class="mb-0">Generate QR Code untuk akses cepat halaman peminjaman</p>
                </div>
            </div>
            <a href="<?php echo e(route('admin.qr.code')); ?>" class="btn btn-primary">
                <i class="fas fa-qrcode me-2"></i>Generate QR Code
            </a>
        </div>
    </div>

    <!-- Peminjaman Aktif -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Peminjaman Aktif</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Nama Peminjam</th>
                            <th>Bidang/Departemen</th>
                            <th>Mobil</th>
                            <th>Tanggal Pinjam</th>
                            <th>Rencana Kembali</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $peminjaman_aktif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($p->nama); ?></td>
                            <td><?php echo e($p->bidang); ?></td>
                            <td>
                                <?php echo e($p->mobil->nama); ?>

                                <br>
                                <small class="text-muted"><?php echo e($p->mobil->plat_nomor); ?></small>
                            </td>
                            <td><?php echo e(\Carbon\Carbon::parse($p->tanggal_pinjam)->format('d/m/Y')); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($p->tanggal_kembali)->format('d/m/Y')); ?></td>
                            <td>
                                <span class="badge bg-warning"><?php echo e(ucfirst($p->status)); ?></span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center">Tidak ada peminjaman aktif</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Status Mobil -->
    <div class="row mt-4">
        <?php $__currentLoopData = $daftarMobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobil): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-4 mb-4">
            <div class="card h-100 
                <?php if($mobil->servis()->where('status', 'proses')->exists()): ?>
                    border-info
                <?php elseif($mobil->status == 'dipinjam'): ?>
                    border-warning
                <?php else: ?>
                    border-success
                <?php endif; ?>">
                <div class="card-body">
                    <h5 class="card-title"><?php echo e($mobil->nama); ?></h5>
                    <p class="card-text">
                        Status: 
                        <?php if($mobil->servis()->where('status', 'proses')->exists()): ?>
                            <span class="text-info">Sedang Diservis</span>
                        <?php elseif($mobil->status == 'dipinjam'): ?>
                            <span class="text-warning">Sedang Dipinjam</span>
                        <?php else: ?>
                            <span class="text-success">Tersedia</span>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>