<?php $__env->startSection('title', 'Riwayat Peminjaman'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Riwayat Peminjaman</h1>
        
        <div class="search-box">
            <form action="<?php echo e(route('admin.riwayat')); ?>" method="GET">
                <div class="mb-3">
                    <select name="search" class="form-select" onchange="this.form.submit()">
                        <option value="">Pilih Mobil</option>
                        <?php $__currentLoopData = $mobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($m->id); ?>" <?php echo e(request('search') == $m->id ? 'selected' : ''); ?>>
                                <?php echo e($m->nama); ?> - <?php echo e($m->plat_nomor); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </form>
        </div>
    </div>

    <!-- Riwayat Table -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead class="bg-soft-maroon">
                        <tr>
                            <th>Nama Peminjam</th>
                            <th>Mobil</th>
                            <th>Tanggal Pinjam</th>
                            <th>Tanggal Kembali</th>
                            <th>Bidang</th>
                            <th>Keperluan</th>
                            <th>Keterangan</th>
                            <th>Bukti Pengembalian</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $riwayat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($r->nama); ?></td>
                            <td>
                                <?php echo e($r->mobil->nama); ?>

                                <br>
                                <small class="text-muted"><?php echo e($r->mobil->plat_nomor); ?></small>
                            </td>
                            <td><?php echo e(\Carbon\Carbon::parse($r->tanggal_pinjam)->format('d/m/Y')); ?></td>
                            <td>
                                <?php if($r->pengembalian && $r->pengembalian->tanggal_kembali): ?>
                                    <?php echo e(\Carbon\Carbon::parse($r->pengembalian->tanggal_kembali)->format('d/m/Y')); ?>

                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($r->bidang); ?></td>
                            <td><?php echo e($r->keperluan); ?></td>
                            <td>
                                <?php if($r->pengembalian && $r->pengembalian->catatan): ?>
                                    <?php echo e($r->pengembalian->catatan); ?>

                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($r->pengembalian && $r->pengembalian->foto_bukti): ?>
                                    <button type="button" 
                                            class="btn btn-sm btn-info"
                                            onclick="showBukti('<?php echo e(asset('storage/'.$r->pengembalian->foto_bukti)); ?>', '<?php echo e($r->mobil->nama); ?>', '<?php echo e($r->pengembalian->catatan ?? '-'); ?>')">
                                        <i class="fas fa-image me-1"></i>Lihat Bukti
                                    </button>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Belum ada bukti</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center">Belum ada riwayat peminjaman yang selesai</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Bukti -->
<div class="modal fade" id="modalBukti" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Bukti Pengembalian</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <img src="" id="imgBukti" class="img-fluid rounded mb-3" style="max-height: 500px;">
                <div class="mt-3">
                    <h6>Keterangan:</h6>
                    <p id="keteranganBukti" class="text-muted"></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        var table = $('#dataTable').DataTable({
            order: [[2, 'desc']], 
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
            },
            dom: 't'
        });
    });

    function showBukti(url, mobilNama, keterangan) {
        document.getElementById('imgBukti').src = url;
        document.querySelector('#modalBukti .modal-title').textContent = 'Bukti Pengembalian - ' + mobilNama;
        document.getElementById('keteranganBukti').textContent = keterangan;
        
        var modal = new bootstrap.Modal(document.getElementById('modalBukti'));
        modal.show();
    }
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .bg-soft-maroon {
        background-color: #ffe6e6; /* Warna merah muda soft */
        color: #800020; /* Warna teks maroon */
    }
    
    .table th {
        vertical-align: middle;
        font-weight: 600;
    }
    
    .table td {
        vertical-align: middle;
    }

    .badge {
        padding: 0.5em 0.8em;
    }

    .btn-info {
        background-color: #0dcaf0;
        border-color: #0dcaf0;
        color: white;
    }

    .btn-info:hover {
        background-color: #0bacce;
        border-color: #0bacce;
        color: white;
    }

    /* Hover effect untuk header */
    .bg-soft-maroon th {
        transition: background-color 0.3s ease;
    }
    
    .bg-soft-maroon th:hover {
        background-color: #ffd9d9;
    }

    /* Tambahkan CSS untuk search box */
    .search-box {
        width: 300px;
    }
    
    .btn-maroon {
        background-color: var(--primary-color);
        color: white;
    }
    
    .btn-maroon:hover {
        background-color: var(--primary-light);
        color: white;
    }
    
    .input-group {
        border-radius: 5px;
        overflow: hidden;
    }
    
    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: none;
    }

    .form-select {
        border-radius: 5px;
        border-color: #ddd;
    }
    
    .form-select:focus {
        border-color: var(--primary-color);
        box-shadow: none;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/admin/riwayat.blade.php ENDPATH**/ ?>