<?php $__env->startSection('title', 'Daftar Mobil'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Daftar Mobil</h1>
        <div class="d-flex gap-3 align-items-center">
            <!-- Tambah form pencarian -->
            <!-- <div class="search-box">
            <form action="<?php echo e(route('admin.mobil')); ?>" method="GET">
                <div class="mb-3">
                    <select name="search" class="form-select" onchange="this.form.submit()">
                        <option value="">Pilih Mobil</option>
                        <?php $__currentLoopData = $mobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($m->id); ?>" <?php echo e(request('search') == $m->id ? 'selected' : ''); ?>>
                                <?php echo e($m->nama); ?> - <?php echo e($m->plat_nomor); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </form>
        </div>
    </div> -->

            <!-- Tombol tambah -->
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#tambahMobilModal">
                <i class="fas fa-plus fa-sm"></i> Tambah Mobil
            </button>
        </div>
    </div>

    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <?php echo e(session('error')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead class="bg-maroon text-white">
                        <tr>
                            <th>Foto</th>
                            <th>Nama Mobil</th>
                            <th>Plat Nomor</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $mobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php if($m->foto): ?>
                                <img src="<?php echo e(asset('storage/'.$m->foto)); ?>" 
                                alt="Foto <?php echo e($m->nama); ?>" 
                                class="img-thumbnail" 
                                style="max-width: 100px;">

                                <?php else: ?>
                                    <span class="text-muted">No image</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($m->nama); ?></td>
                            <td><?php echo e($m->plat_nomor); ?></td>
                            <td>
                                <span class="badge <?php echo e($m->status == 'tersedia' ? 'bg-success' : 'bg-danger'); ?>">
                                    <?php echo e(ucfirst($m->status)); ?>

                                </span>
                            </td>
                            <td>
                                <button type="button" class="btn btn-sm btn-info" 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#editMobilModal<?php echo e($m->id); ?>">
                                    <i class="fas fa-edit"></i> Edit
                                </button>
                                <form action="<?php echo e(route('admin.mobil.delete', $m->id)); ?>" 
                                      method="POST"
                                      class="d-inline"
                                      onsubmit="return confirm('Yakin ingin menghapus mobil ini?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah Mobil -->
<div class="modal fade" id="tambahMobilModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Mobil</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('admin.mobil.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label>Nama Mobil</label>
                        <input type="text" class="form-control" name="nama" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Plat Nomor</label>
                        <input type="text" class="form-control" name="plat_nomor" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Foto</label>
                        <input type="file" class="form-control" name="foto" accept="image/*" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit untuk setiap mobil -->
<?php $__currentLoopData = $mobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editMobilModal<?php echo e($m->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Mobil</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('admin.mobil.update', $m->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label>Nama Mobil</label>
                        <input type="text" class="form-control" name="nama" value="<?php echo e($m->nama); ?>" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Plat Nomor</label>
                        <input type="text" class="form-control" name="plat_nomor" value="<?php echo e($m->plat_nomor); ?>" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Foto</label>
                        <?php if($m->foto): ?>
                            <div class="mb-2">
                            <img src="<?php echo e(asset('storage/'.$m->foto)); ?>" 
                            alt="Foto <?php echo e($m->nama); ?>" 
                            class="img-thumbnail" 
                            style="max-width: 100px;">

                            </div>
                        <?php endif; ?>
                        <input type="file" class="form-control" name="foto" accept="image/*">
                        <small class="text-muted">Biarkan kosong jika tidak ingin mengubah foto</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('#dataTable').DataTable();

        // Handle modal events
        $('.modal').on('shown.bs.modal', function () {
            $(this).find('[autofocus]').focus();
        });

        // Handle form submission
        $('form').on('submit', function() {
            $(this).find('button[type="submit"]').prop('disabled', true);
        });

        // Show success/error messages
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: "<?php echo session('error'); ?>",
                timer: 3000,
                showConfirmButton: false
            });
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .bg-maroon {
        background-color: #800020;
    }
    
    .modal-header {
        background: linear-gradient(135deg, #800020, #a31545);
        color: white;
    }
    
    .btn-primary {
        background-color: #800020;
        border-color: #800020;
    }
    
    .btn-primary:hover {
        background-color: #a31545;
        border-color: #a31545;
    }
    
    .table th {
        vertical-align: middle;
    }
    
    .badge {
        padding: 8px 12px;
        font-size: 0.9rem;
    }

    .search-box {
        width: 300px;
    }
    
    .form-select {
        border-radius: 5px;
        border-color: #ddd;
    }
    
    .form-select:focus {
        border-color: var(--primary-color);
        box-shadow: none;
    }

    .gap-3 {
        gap: 1rem;
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/admin/mobil.blade.php ENDPATH**/ ?>