<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peminjaman Mobil</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #800020;      /* Maroon */
            --primary-light: #a31545;      /* Lighter Maroon */
            --primary-dark: #5c0018;       /* Darker Maroon */
            --accent-color: #FFD700;       /* Gold */
            --accent-light: #FFE55C;       /* Light Gold */
        }

        body { 
            background-color: #fff5f5; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .navbar-custom {
            background: var(--primary-color);
            padding: 0;
            position: relative;
            height: 80px;
        }
        .container.d-flex.justify-content-center {
            height: 100%;
            align-items: center;
        }
        .nav-link {
            color: white !important;
            padding: 18px 35px !important;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            border-radius: 30px !important; /* Memastikan melengkung */
            margin: 0 5px;
        }
        .nav-link:hover {
            transform: translateY(-2px);
            background: rgba(255,255,255,0.1);
        }
        .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 3px;
            background: #FFD700;
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }
        .nav-link:hover::after {
            width: 80%;
        }
        .nav-link.active {
            background: #FFD700;
            color: var(--primary-color) !important;
            transform: translateY(0);
            border-radius: 30px !important;
            box-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
        }
        .nav-link.active::after {
            display: none;
        }
        .nav-link i {
            margin-right: 8px;
            transition: transform 0.3s ease;
        }
        .nav-link:hover i {
            transform: scale(1.2);
        }
        .nav-right {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
        }
        .btn-admin {
            background: #FFD700;
            color: var(--primary-color);
            font-weight: 600;
            padding: 12px 30px;
            border: none;
            border-radius: 30px !important;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .btn-admin:hover {
            background: #f8d000;
            color: var(--primary-color);
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.15);
        }
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(128, 0, 32, 0.1);
            margin-bottom: 25px;
        }
        .card-header {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-light));
            color: white;
            padding: 1.5rem;
            border-bottom: none;
        }
        .car-available {
            border: 2px solid var(--accent-color);
            transition: all 0.3s;
        }
        .car-available:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(128, 0, 32, 0.2);
        }
        .form-control, .form-select {
            border-radius: 8px;
            padding: 0.8rem 1rem;
            border: 1px solid rgba(128, 0, 32, 0.2);
            transition: all 0.3s;
        }
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(128, 0, 32, 0.1);
        }
        .form-label {
            font-weight: 500;
            margin-bottom: 0.5rem;
            color: #444;
        }
        .step-header {
            background: rgba(128, 0, 32, 0.05);
            padding: 1rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            border-left: 4px solid var(--primary-color);
            animation: fadeIn 0.5s ease-in;
        }
        .btn-submit {
            background: var(--accent-color) !important;  /* Warna kuning */
            color: var(--primary-dark) !important;
            font-weight: bold;
            border: none;
            transition: all 0.3s;
        }
        .btn-submit:hover {
            background: var(--accent-light) !important;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
        }
        .alert-container {
            animation: slideIn 0.5s ease-out;
        }
        @keyframes slideIn {
            0% {
                transform: translateX(100%);
            }
            100% {
                transform: translateX(0);
            }
        }
        .alert {
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            border: none;
            border-radius: 10px;
            padding: 1rem 1.5rem;
        }
        .alert-success {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-light));
            border-left: 4px solid var(--accent-color);
            color: white;
        }
        .btn-close {
            filter: brightness(0) invert(1);
        }
        .car-selected {
            transform: translateY(-10px);
            border: 3px solid var(--accent-color);
            box-shadow: 0 8px 25px rgba(255, 215, 0, 0.3);
            position: relative;
        }
        
        .car-selected::before {
            content: '✓ Mobil Dipilih';
            position: absolute;
            top: -15px;
            right: 15px;
            background: var(--accent-color);
            color: var(--primary-dark);
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 0.9rem;
            z-index: 1;
            box-shadow: 0 4px 10px rgba(255, 215, 0, 0.3);
        }
        
        .car-selected .card-body {
            background: rgba(255, 215, 0, 0.05);
        }

        .car-selected .btn-primary {
            background: var(--accent-color) !important;
            color: var(--primary-dark) !important;
            font-weight: bold;
        }
        
        .car-selected .btn-primary:hover {
            background: var(--primary-light) !important;
        }
        
        .selected-car-info {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-light));
            border: 2px solid var(--accent-color);
            color: white;
            padding: 1rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            display: none;
        }
        
        .change-car-btn {
            background: var(--accent-color);
            border: none;
            color: var(--primary-dark);
            font-weight: bold;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            transition: all 0.3s;
        }
        
        .change-car-btn:hover {
            background: var(--accent-light);
            color: var(--primary-color);
        }

        .badge.bg-success {
            background: var(--accent-color) !important;
            color: var(--primary-dark);
            font-weight: bold;
            padding: 8px 15px;
        }

        .badge.bg-danger {
            background: #dc3545 !important;
            color: white;
            font-weight: bold;
            padding: 8px 15px;
        }

        .car-unavailable {
            opacity: 0.7;
            filter: grayscale(50%);
            pointer-events: none;
        }

        .car-unavailable .card-body {
            position: relative;
        }

        .car-unavailable .card-body::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(220, 53, 69, 0.1);
            border-radius: 15px;
        }

        /* Style untuk tombol */
        .btn {
            border-radius: 8px;
            font-weight: 500;
            padding: 0.8rem 1.5rem;
        }

        /* Tambahkan style untuk animasi fade in */
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Update style untuk tombol pilih mobil */
        .btn-primary {
            background: var(--primary-color) !important;
            border: none;
            color: white !important;
            font-weight: 500;
            transition: all 0.3s;
        }

        .btn-primary:hover {
            background: var(--primary-light) !important;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(128, 0, 32, 0.2);
        }

        /* Update style untuk notifikasi */
        .alert-notification {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1050;
            min-width: 300px;
            text-align: center;
            background: linear-gradient(135deg, var(--primary-light), var(--primary-color));
            color: white;
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(128, 0, 32, 0.2);
            padding: 20px;
            animation: fadeInScale 0.5s ease-out;
        }

        .alert-notification i {
            font-size: 2.5rem;
            color: var(--accent-color);
            margin-bottom: 15px;
        }

        .alert-notification h4 {
            color: white;
            font-weight: bold;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.2);
        }

        .alert-notification p {
            color: white;
            margin-bottom: 0;
            font-size: 1.1rem;
        }

        /* Tambahkan style untuk footer */
        footer .card {
            background: rgba(128, 0, 32, 0.05);
            border: none;
            transition: all 0.3s;
        }

        footer .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 15px rgba(128, 0, 32, 0.1);
        }

        footer a:hover {
            color: var(--primary-light) !important;
            text-decoration: underline !important;
        }

        footer .fas {
            font-size: 1.2rem;
        }

        footer h5 {
            color: var(--primary-color);
            font-weight: bold;
        }

        .swal2-popup {
            padding: 2rem;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }

        .swal2-title {
            font-size: 1.5rem !important;
            font-weight: 600 !important;
            color: #333 !important;
        }

        .swal2-html-container {
            font-size: 1rem !important;
            line-height: 1.6 !important;
        }

        .swal2-confirm {
            padding: 0.5rem 2rem !important;
            font-weight: 500 !important;
        }

        .text-success {
            color: #28a745 !important;
        }

        /* Animasi untuk mobil yang dipilih */
        @keyframes selectedPulse {
            0% { box-shadow: 0 0 0 0 rgba(255, 215, 0, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(255, 215, 0, 0); }
            100% { box-shadow: 0 0 0 0 rgba(255, 215, 0, 0); }
        }

        .car-selected {
            animation: selectedPulse 2s infinite;
        }

        /* Tambahkan style untuk mobile */
        @media (max-width: 768px) {
            .card-header h3 {
                font-size: 1.5rem;
            }

            .step-header h5 {
                font-size: 1.1rem;
            }

            .btn {
                padding: 0.6rem 1rem;
            }

            .detail-peminjaman strong {
                min-width: 100px;
            }

            /* Perbaiki spacing di mobile */
            .container {
                padding: 0 15px;
            }

            .card {
                margin: 10px 0;
            }

            /* Perbaiki ukuran gambar di mobile */
            .img-thumbnail {
                width: 100%;
                height: auto;
            }
        }

        .success-notification {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            padding: 20px 30px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            z-index: 1000;
            text-align: center;
            border: 2px solid #28a745;
        }
        
        .success-notification i {
            color: #28a745;
            font-size: 24px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-custom">
        <div class="container d-flex justify-content-center">
            <a class="nav-link <?php echo e(request()->routeIs('user.home') ? 'active' : ''); ?>" href="<?php echo e(route('user.home')); ?>">
                <i class="fas fa-home"></i> Home
            </a>
            <a class="nav-link <?php echo e(request()->routeIs('user.peminjaman') ? 'active' : ''); ?>" href="<?php echo e(route('user.peminjaman')); ?>">
                <i class="fas fa-car"></i> Peminjaman
            </a>
            <a class="nav-link <?php echo e(request()->routeIs('user.pengembalian') ? 'active' : ''); ?>" href="<?php echo e(route('user.pengembalian')); ?>">
                <i class="fas fa-undo"></i> Pengembalian
            </a>
        </div>
        <!-- <div class="nav-right">
            <a class="btn btn-admin" href="<?php echo e(route('admin.login')); ?>">
                <i class="fas fa-user"></i> Admin
            </a>
        </div> -->
    </nav>

    <!-- Tambahkan di bawah navbar, sebelum container -->
    <?php if(session('success') && session('peminjaman_baru')): ?>
    <div class="success-notification">
        <i class="fas fa-check-circle"></i>
        <h5 class="mb-2">Peminjaman Berhasil!</h5>
        <p class="mb-0">Silakan ambil kunci di ruang admin.</p>
    </div>
    
    <script>
        // Hilangkan notifikasi setelah 3 detik
        setTimeout(function() {
            document.querySelector('.success-notification').style.display = 'none';
        }, 3000);
    </script>
    <?php endif; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="mb-0 text-center">Form Peminjaman Mobil</h3>
                    </div>
                    <div class="card-body p-4">
                        <!-- Step 1: Pilih Tanggal Peminjaman -->
                        <div class="step-header">
                            <h5 class="mb-0">
                                <i class="fas fa-calendar-alt me-2"></i>
                                Langkah 1: Pilih Tanggal Peminjaman
                            </h5>
                        </div>
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">Tanggal Peminjaman</label>
                                    <input type="date" class="form-control" id="tanggal_pinjam" name="tanggal_pinjam" 
                                           min="<?php echo e(date('Y-m-d')); ?>" required onchange="checkAvailability()">
                                </div>
                            </div>
                        </div>
                        <small class="text-muted">
                            * Peminjaman hanya tersedia pada hari kerja (Senin-Jumat) pukul 08:00-16:00
                        </small>

                        <!-- Step 2: Pilih Mobil -->
                        <div id="mobilSection" style="display: none;">
                            <div class="step-header mt-4">
                                <h5 class="mb-0">
                                    <i class="fas fa-car me-2"></i>
                                    Langkah 2: Pilih Mobil yang Tersedia
                                </h5>
                            </div>
                            
                            <!-- Tambahkan info mobil yang dipilih -->
                            <div id="selectedCarInfo" class="selected-car-info">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <i class="fas fa-check-circle me-2"></i>
                                        Mobil yang dipilih: <strong id="selectedCarName"></strong>
                                    </div>
                                    <button type="button" class="change-car-btn" onclick="ubahMobil()">
                                        <i class="fas fa-exchange-alt me-2"></i> Ganti Mobil
                                    </button>
                                </div>
                            </div>
                            
                            <div class="row" id="daftarMobil">
                                <?php $__empty_1 = true; $__currentLoopData = $daftarMobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobil): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-md-4 mb-4">
                                    <div class="card h-100" data-mobil-id="<?php echo e($mobil->id); ?>">
                                        <div class="card-img-top" style="height: 200px; overflow: hidden;">
                                        <?php if($mobil->foto): ?>
                            <div class="d-flex justify-content-center">
                                <img src="<?php echo e(asset('storage/'.$mobil->foto)); ?>" 
                                    alt="Foto <?php echo e($mobil->nama); ?>" 
                                    class="img-thumbnail rounded shadow" 
                                    style="width: 250px; height: 150px; object-fit: cover;">
                            </div>
                        <?php else: ?>
                            <div class="d-flex justify-content-center align-items-center bg-light rounded shadow" 
                                style="width: 100px; height: 150px;">
                                <i class="fas fa-car fa-3x text-muted"></i>
                            </div>
                        <?php endif; ?>
                                        </div>
                                        <div class="card-body">
                                            <h5 class="card-title"><?php echo e($mobil->nama); ?></h5>
                                            <p class="card-text">
                                                <small class="text-muted"><?php echo e($mobil->plat_nomor); ?></small>
                                                <br>
                                                <span class="badge bg-<?php echo e($mobil->status == 'tersedia' ? 'success' : 'warning'); ?>">
                                                    <?php echo e(ucfirst($mobil->status)); ?>

                                                </span>
                                            </p>
                                            <?php if($mobil->status == 'tersedia'): ?>
                                                <button type="button" class="btn btn-primary w-100" 
                                                        onclick="pilihMobil('<?php echo e($mobil->id); ?>', '<?php echo e($mobil->nama); ?> (<?php echo e($mobil->plat_nomor); ?>)')">
                                                    <i class="fas fa-check-circle me-2"></i>
                                                    Pilih Mobil
                                                </button>
                                            <?php else: ?>
                                                <button class="btn btn-secondary w-100" disabled>
                                                    <i class="fas fa-clock me-2"></i>Sedang Dipinjam
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="col-12 text-center">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i>
                                        Tidak ada mobil yang tersedia saat ini
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Langkah 3: Tanggal Pengembalian -->
                        <div id="pengembalianSection" style="display: none;">
                            <div class="card">
                                <div class="card-body">
                                    <div class="step-header">
                                <h5 class="mb-0">
                                    <i class="fas fa-calendar-check me-2"></i>
                                            Langkah 3: Tanggal Pengembalian
                                </h5>
                            </div>

                                    <div class="mb-4">
                                        <label class="form-label">Tanggal Kembali</label>
                                        <input type="date" 
                                               class="form-control" 
                                               id="tanggal_kembali" 
                                               onchange="pilihTanggalKembali()"
                                               min="<?php echo e(date('Y-m-d', strtotime('+1 day'))); ?>" 
                                               required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Langkah 4: Form Data Diri -->
                        <div id="formPeminjaman" style="display: none;">
                            <form action="<?php echo e(route('user.peminjaman.store')); ?>" method="POST" id="peminjamanForm">
                            <?php echo csrf_field(); ?>
                            <!-- Hidden inputs untuk data yang sudah dipilih -->
                            <input type="hidden" name="mobil_id" id="mobil_id" required>
                            <input type="hidden" name="tanggal_pinjam" id="selected_tanggal_pinjam" required>
                            <input type="hidden" name="tanggal_kembali" id="selected_tanggal_kembali" required>
                            
                            <div class="step-header mt-4">
                                <h5 class="mb-0">
                                    <i class="fas fa-user me-2"></i>
                                    Langkah 4: Isi Data Diri
                                </h5>
                            </div>

                            <!-- Ringkasan Peminjaman -->
                            <div class="card mb-4 bg-light">
                                <div class="card-body">
                                    <h6 class="card-title mb-3">Detail Peminjaman:</h6>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <small class="text-muted d-block">Mobil yang dipilih:</small>
                                            <strong id="ringkasan_mobil"></strong>
                                        </div>
                                        <div class="col-md-4">
                                            <small class="text-muted d-block">Tanggal Pinjam:</small>
                                            <strong id="ringkasan_tgl_pinjam"></strong>
                                        </div>
                                          
                                        <div class="col-md-4">
                                            <small class="text-muted d-block">Tanggal Kembali:</small>
                                            <strong id="ringkasan_tgl_kembali"></strong>
                                            </div>
                                           
                                    </div>
                                </div>
                            </div>

                            <!-- Form Fields -->
                            <div class="mb-3">
                                <label class="form-label">Nama Lengkap</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['nama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       name="nama" value="<?php echo e(old('nama')); ?>" required>
                                <?php $__errorArgs = ['nama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Bidang/Departemen</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['bidang'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       name="bidang" value="<?php echo e(old('bidang')); ?>" required>
                                <?php $__errorArgs = ['bidang'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Keperluan</label>
                                <textarea class="form-control <?php $__errorArgs = ['keperluan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          name="keperluan" rows="3" required><?php echo e(old('keperluan')); ?></textarea>
                                <?php $__errorArgs = ['keperluan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <button type="submit" class="btn btn-primary w-100" id="submitBtn">
                                <i class="fas fa-paper-plane me-2"></i>Ajukan Peminjaman
                            </button>
                        </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tambahkan modal notifikasi -->
    <div class="modal fade" id="notificationModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0">
                <div class="modal-body text-center p-4" style="background: linear-gradient(135deg, var(--primary-color), var(--primary-light)); color: white;">
                    <div class="mb-4">
                        <i class="fas fa-check-circle" style="font-size: 4rem; color: var(--accent-color);"></i>
                    </div>
                    <h4 class="mb-3" id="modalMobilNama"></h4>
                    <p class="mb-4">Silahkan ambil kunci di ruang admin.</p>
                    <a href="<?php echo e(route('user.home')); ?>" class="btn btn-lg" 
                       style="background: var(--accent-color); color: var(--primary-dark); font-weight: bold;">
                        OK
                    </a>
                </div>
            </div>
        </div>
    </div>

    <?php if(session('showModal')): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const modal = new bootstrap.Modal(document.getElementById('notificationModal'));
            modal.show();
        });
    </script>
    <?php endif; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Sembunyikan sections di awal
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('mobilSection').style.display = 'none';
            document.getElementById('pengembalianSection').style.display = 'none';
            document.getElementById('formPeminjaman').style.display = 'none';
        });

        function checkAvailability() {
            const tanggal = document.getElementById('tanggal_pinjam').value;
            
            if (tanggal) {
                // Langsung tampilkan daftar mobil
                document.getElementById('mobilSection').style.display = 'block';
                document.getElementById('mobilSection').scrollIntoView({ behavior: 'smooth' });
            }
        }

        function pilihMobil(mobilId, mobilNama) {
            // Hapus class car-selected dari semua card
            document.querySelectorAll('.card').forEach(card => {
                card.classList.remove('car-selected');
            });

            // Tambah class car-selected ke mobil yang dipilih
            const selectedCard = document.querySelector(`[data-mobil-id="${mobilId}"]`);
            selectedCard.classList.add('car-selected');

            // Tambahkan efek highlight sementara
            selectedCard.style.transition = 'all 0.3s ease';
            selectedCard.style.transform = 'scale(1.05)';
            setTimeout(() => {
                selectedCard.style.transform = 'translateY(-10px)';
            }, 300);

            // Set nilai mobil_id dan lainnya seperti sebelumnya
            document.getElementById('mobil_id').value = mobilId;
            const tanggalPinjam = document.getElementById('tanggal_pinjam').value;
            document.getElementById('selected_tanggal_pinjam').value = tanggalPinjam;
            document.getElementById('ringkasan_mobil').textContent = mobilNama;
            document.getElementById('ringkasan_tgl_pinjam').textContent = formatDate(tanggalPinjam);

            // Tampilkan section pengembalian
            const pengembalianSection = document.getElementById('pengembalianSection');
            pengembalianSection.style.display = 'block';
            pengembalianSection.classList.add('fade-in');
            pengembalianSection.scrollIntoView({ behavior: 'smooth' });
        }

        function ubahMobil() {
            // Reset semua langkah setelah langkah 2
            document.getElementById('pengembalianSection').style.display = 'none';
            document.getElementById('formPeminjaman').style.display = 'none';
            document.getElementById('tanggal_kembali').value = '';
            
            // Hapus highlight dari mobil yang dipilih
            document.querySelectorAll('.car-available').forEach(card => {
                card.classList.remove('car-selected');
            });
            
            // Sembunyikan info mobil yang dipilih
            document.getElementById('selectedCarInfo').style.display = 'none';
            
            // Scroll ke daftar mobil
            document.getElementById('mobilSection').scrollIntoView({ behavior: 'smooth' });
        }

        function pilihTanggalKembali() {
            const tanggalKembali = document.getElementById('tanggal_kembali').value;
            
            if (tanggalKembali) {
                // Set nilai tanggal kembali
                document.getElementById('selected_tanggal_kembali').value = tanggalKembali;
                
                // Update ringkasan
                document.getElementById('ringkasan_tgl_kembali').textContent = formatDate(tanggalKembali);
                
                // Tampilkan form peminjaman
                document.getElementById('formPeminjaman').style.display = 'block';
                document.getElementById('formPeminjaman').scrollIntoView({ behavior: 'smooth' });
            }
        }

        // Helper function untuk format tanggal
        function formatDate(dateString) {
            const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
            return new Date(dateString).toLocaleDateString('id-ID', options);
        }

        // Form submit handler
        document.getElementById('peminjamanForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Validasi semua field terisi
            const mobilId = document.getElementById('mobil_id').value;
            const tanggalPinjam = document.getElementById('selected_tanggal_pinjam').value;
            const tanggalKembali = document.getElementById('selected_tanggal_kembali').value;
            
            if (!mobilId || !tanggalPinjam || !tanggalKembali) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Mohon lengkapi semua data peminjaman'
                });
                return;
            }
            
            if (this.checkValidity()) {
                Swal.fire({
                    title: 'Memproses Peminjaman...',
                    html: 'Mohon tunggu sebentar',
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    didOpen: () => {
                        Swal.showLoading();
                        setTimeout(() => {
                            this.submit();
                        }, 1000);
                    }
                });
            } else {
                this.reportValidity();
            }
        });

        document.addEventListener('DOMContentLoaded', function () {
            const tanggalPinjamInput = document.getElementById('tanggal_pinjam');
            const tanggalKembaliInput = document.getElementById('tanggal_kembali');

            // Set min date untuk tanggal pinjam (tidak bisa pilih tanggal yang sudah lewat)
            const today = new Date().toISOString().split('T')[0];
            tanggalPinjamInput.setAttribute('min', today);

            tanggalPinjamInput.addEventListener('change', function () {
                let selectedDate = new Date(this.value);
                let dayOfWeek = selectedDate.getDay(); // 0 = Minggu, 6 = Sabtu

                // Reset tanggal kembali saat tanggal pinjam berubah
                tanggalKembaliInput.value = '';

                // Cek apakah hari yang dipilih adalah Sabtu/Minggu
                if (dayOfWeek === 0 || dayOfWeek === 6) {
                    alert('Peminjaman hanya bisa dilakukan pada hari Senin-Jumat!');
                    this.value = ''; // Kosongkan input
                    return;
                }

                // Set min date untuk tanggal kembali
                tanggalKembaliInput.setAttribute('min', this.value);

                // Jika memilih Kamis, otomatis set max tanggal kembali Jumat
                if (dayOfWeek === 4) { // Kamis
                    let friday = new Date(selectedDate);
                    friday.setDate(friday.getDate() + 1);
                    let maxDate = friday.toISOString().split('T')[0];
                    tanggalKembaliInput.setAttribute('max', maxDate);
                    
                    // Tampilkan pesan informasi
                    alert('Jika meminjam pada hari Kamis, mobil harus dikembalikan pada hari Jumat!');
                } else {
                    // Default, max tanggal kembali adalah Jumat di minggu yang sama
                    let friday = new Date(selectedDate);
                    while (friday.getDay() !== 5) { // Cari hari Jumat terdekat
                        friday.setDate(friday.getDate() + 1);
                    }
                    let maxDate = friday.toISOString().split('T')[0];
                    tanggalKembaliInput.setAttribute('max', maxDate);
                }

                // Enable input tanggal kembali
                tanggalKembaliInput.disabled = false;
            });

            tanggalKembaliInput.addEventListener('change', function() {
                let tanggalPinjam = new Date(tanggalPinjamInput.value);
                let tanggalKembali = new Date(this.value);
                
                // Validasi tanggal kembali harus setelah tanggal pinjam
                if (tanggalKembali < tanggalPinjam) {
                    alert('Tanggal kembali harus setelah tanggal pinjam!');
                    this.value = '';
                    return;
                }

                // Validasi tidak boleh melewati hari Jumat
                let dayOfWeek = tanggalKembali.getDay();
                if (dayOfWeek === 6 || dayOfWeek === 0) {
                    alert('Tanggal kembali tidak boleh di hari Sabtu atau Minggu!');
                    this.value = '';
                    return;
                }

                // Jika tanggal pinjam Kamis, wajib kembali Jumat
                if (tanggalPinjam.getDay() === 4 && dayOfWeek !== 5) {
                    alert('Jika meminjam hari Kamis, wajib dikembalikan hari Jumat!');
                    this.value = '';
                    return;
                }
            });
        });

        // Helper function untuk format tanggal
        function formatDate(date) {
            let d = new Date(date),
                month = '' + (d.getMonth() + 1),
                day = '' + d.getDate(),
                year = d.getFullYear();

            if (month.length < 2) month = '0' + month;
            if (day.length < 2) day = '0' + day;

            return [year, month, day].join('-');
        }
    </script>

    <!-- Tambahkan di bagian bawah sebelum </body> -->
    <footer class="mt-5 mb-4">
        <div class="container">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Kontak Kami</h5>
                            <div class="d-flex flex-column gap-2">
                                <div>
                                    <i class="fas fa-envelope me-2" style="color: var(--primary-color);"></i>
                                    <a href="mailto:disnakertrans@jogjaprov.go.id" class="text-decoration-none" style="color: var(--primary-color);">
                                        disnakertrans@jogjaprov.go.id
                                    </a>
                                </div>
                                <div>
                                    <i class="fas fa-phone me-2" style="color: var(--primary-color);"></i>
                                    <a href="tel:+62274512904" class="text-decoration-none" style="color: var(--primary-color);">
                                        (0274) 512904
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Lokasi</h5>
                            <div>
                                <i class="fas fa-map-marker-alt me-2" style="color: var(--primary-color);"></i>
                                <span style="color: var(--primary-dark);">
                                    Jl. Ring Road Utara Gg. Meguwo, Meguwo, Maguwoharjo, Kec. Depok, Kabupaten Sleman, Daerah Istimewa Yogyakarta 55282
                                </span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Jam Operasional</h5>
                            <div class="d-flex flex-column gap-2">
                                <div>
                                    <i class="fas fa-clock me-2" style="color: var(--primary-color);"></i>
                                    <span style="color: var(--primary-dark);">
                                        Senin - Kamis: 07:30 - 16:00
                                    </span>
                                </div>
                                <div>
                                    <i class="fas fa-clock me-2" style="color: var(--primary-color);"></i>
                                    <span style="color: var(--primary-dark);">
                                        Jumat: 07:30 - 14:30
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</body>
</html> <?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/user/peminjaman.blade.php ENDPATH**/ ?>