<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Peminjaman Mobil - Disnakertrans DIY</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #800020;
            --primary-light: #a31545;
        }

        body {
            background-color: #fff5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* Navbar Styles */
        .navbar-custom {
            background: var(--primary-color);
            padding: 0;
            position: relative;
            height: 80px;
        }

        .container {
            position: relative;
        }

        .container.d-flex.justify-content-center {
            height: 100%;
            align-items: center;
        }

        .navbar-nav {
            display: flex;
            gap: 1.5rem;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
        }

        .nav-right {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
        }

        .nav-link {
            color: white !important;
            padding: 18px 35px !important;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            border-radius: 30px;
            margin: 0 5px;
        }

        .nav-link:hover {
            transform: translateY(-2px);
        }

        .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 3px;
            background: #FFD700;
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }

        .nav-link:hover::after {
            width: 80%;
        }

        .nav-link.active {
            background: #FFD700;
            color: var(--primary-color) !important;
            transform: translateY(0);
            border-radius: 30px;
            box-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
        }

        .nav-link.active::after {
            display: none;
        }

        .nav-link i {
            margin-right: 8px;
            transition: transform 0.3s ease;
        }

        .nav-link:hover i {
            transform: scale(1.2);
        }

        .btn-admin {
            background: #FFD700;
            color: var(--primary-color);
            font-weight: 600;
            padding: 12px 30px;
            border: none;
            border-radius: 4px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }

        .btn-admin:hover {
            background: #f8d000;
            color: var(--primary-color);
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.15);
        }

        /* Content Styles */
        .text-maroon {
            color: var(--primary-color) !important;
        }

        .section-header h2 {
            position: relative;
            display: inline-block;
            padding-bottom: 10px;
        }

        .section-header h2::after {
            content: '';
            position: absolute;
            display: block;
            width: 50px;
            height: 3px;
            background: var(--primary-color);
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
        }

        .card {
            border-radius: 15px;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .hover-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
        }

        .card-img-wrapper {
            height: 200px;
            overflow: hidden;
        }

        .card-img-top {
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .hover-card:hover .card-img-top {
            transform: scale(1.1);
        }

        /* Button Styles */
        .btn {
            border-radius: 8px;
            padding: 12px 20px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: var(--primary-color);
            border: none;
        }

        .btn-primary:hover {
            background: var(--primary-light);
            transform: translateY(-2px);
        }

        .btn-warning {
            background: #FFD700;
            border: none;
            color: var(--primary-color);
            font-weight: 600;
        }

        .btn-warning:hover {
            background: #f8d000;
            color: var(--primary-color);
        }

        /* Modal Styles */
        .modal-content {
            border-radius: 15px;
            border: none;
        }

        .modal-header {
            background: #f8f9fa;
        }

        .table td {
            padding: 10px 0;
        }

        /* Footer Styles */
        footer {
            background: white;
            padding: 2rem 0;
            margin-top: 3rem;
        }

        footer .card {
            background: rgba(128, 0, 32, 0.05);
            border: none;
        }

        footer a {
            color: var(--primary-color);
            text-decoration: none;
        }

        footer a:hover {
            color: var(--primary-light);
        }

        .welcome-section h1 {
            font-size: 2.5rem;
            font-weight: 600;
        }

        .car-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .car-image {
            height: 200px;
            overflow: hidden;
        }

        .car-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .car-info {
            padding: 20px;
        }

        .car-info h3 {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 10px;
        }

        .plat-nomor {
            color: #666;
            font-size: 0.9rem;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-custom">
        <div class="container d-flex justify-content-center">
            <a class="nav-link <?php echo e(request()->routeIs('user.home') ? 'active' : ''); ?>" href="<?php echo e(route('user.home')); ?>">
                <i class="fas fa-home"></i> Home
            </a>
            <a class="nav-link <?php echo e(request()->routeIs('user.peminjaman') ? 'active' : ''); ?>" href="<?php echo e(route('user.peminjaman')); ?>">
                <i class="fas fa-car"></i> Peminjaman
            </a>
            <a class="nav-link <?php echo e(request()->routeIs('user.pengembalian') ? 'active' : ''); ?>" href="<?php echo e(route('user.pengembalian')); ?>">
                <i class="fas fa-undo"></i> Pengembalian
            </a>
        </div>
        <div class="nav-right">
            <a class="btn btn-admin" href="<?php echo e(route('admin.login')); ?>">
                <i class="fas fa-user"></i> Admin
            </a>
        </div>
    </nav>

    <!-- Content -->
    <div class="container py-5">
        <!-- Welcome Section -->
        <div class="welcome-section text-center mb-5">
            <h1 class="text-maroon mb-3">Selamat Datang di Sistem Peminjaman Mobil</h1>
            <p class="text-muted">
                Sistem peminjaman mobil dinas yang mudah, cepat, dan efisien untuk Dinas Tenaga Kerja dan Transmigrasi DIY
            </p>
        </div>

        <!-- Armada Section -->
        <div class="armada-section">
            <h2 class="text-center text-maroon mb-4">
                <i class="fas fa-car"></i> Armada Kami
            </h2>
            
            <div class="row g-4 justify-content-center">
                <?php $__currentLoopData = $daftarMobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4">
                    <div class="car-card">
                        <div class="car-image">
                            <?php if($m->foto): ?>
                                <img src="<?php echo e(asset('storage/'.$m->foto)); ?>" alt="<?php echo e($m->nama); ?>">
                            <?php else: ?>
                                <img src="<?php echo e(asset('images/default-car.png')); ?>" alt="Default">
                            <?php endif; ?>
                        </div>
                        <div class="car-info">
                            <h3><?php echo e($m->nama); ?></h3>
                            <p class="plat-nomor"><?php echo e($m->plat_nomor); ?></p>
                            <p>Status: 
                                <?php if($m->status == 'servis'): ?>
                                    <span class="badge badge-warning">Sedang Diservis</span>
                                    <?php if($m->jadwalServis->isNotEmpty()): ?>
                                        <br>
                                        <small class="text-muted">
                                            Jadwal Servis: <?php echo e(\Carbon\Carbon::parse($m->jadwalServis->first()->tanggal_servis)->format('d/m/Y')); ?>

                                            <br>
                                            Keterangan: <?php echo e($m->jadwalServis->first()->keterangan); ?>

                                        </small>
                                    <?php endif; ?>
                                <?php elseif($m->status == 'tersedia'): ?>
                                    <span class="badge badge-success">Tersedia</span>
                                <?php elseif($m->status == 'dipinjam'): ?>
                                    <span class="badge badge-danger">Sedang Dipinjam</span>
                                <?php endif; ?>
                            </p>
                            <?php if($m->status == 'dipinjam'): ?>
                                <button class="btn btn-warning w-100 mb-2" onclick="showDetail('<?php echo e($m->id); ?>')">
                                    <i class="fas fa-info-circle"></i> Detail Peminjaman
                                </button>
                                <button class="btn btn-secondary w-100" disabled>
                                    <i class="fas fa-clock"></i> Tidak Tersedia
                                </button>
                            <?php elseif($m->status == 'servis'): ?>
                                <button class="btn btn-secondary w-100" disabled>
                                    <i class="fas fa-tools"></i> Sedang Dalam Perbaikan
                                </button>
                            <?php else: ?>
                                <a href="<?php echo e(route('user.peminjaman', ['mobil' => $m->id])); ?>" 
                                   class="btn btn-primary w-100">
                                    <i class="fas fa-key"></i> Pinjam Mobil
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="mt-5 mb-4">
        <div class="container">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Kontak Kami</h5>
                            <div class="d-flex flex-column gap-2">
                                <div>
                                    <i class="fas fa-envelope me-2 text-maroon"></i>
                                    <a href="mailto:disnakertrans@jogjaprov.go.id">disnakertrans@jogjaprov.go.id</a>
                                </div>
                                <div>
                                    <i class="fas fa-phone me-2 text-maroon"></i>
                                    <a href="tel:+62274512904">(0274) 512904</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Lokasi</h5>
                            <div>
                                <i class="fas fa-map-marker-alt me-2 text-maroon"></i>
                                <span>Jl. Ring Road Utara Gg. Meguwo, Meguwo, Maguwoharjo, Kec. Depok, Kabupaten Sleman, DIY 55282</span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Jam Operasional</h5>
                            <div class="d-flex flex-column gap-2">
                                <div>
                                    <i class="fas fa-clock me-2 text-maroon"></i>
                                    <span>Senin - Kamis: 07:30 - 16:00</span>
                                </div>
                                <div>
                                    <i class="fas fa-clock me-2 text-maroon"></i>
                                    <span>Jumat: 07:30 - 14:30</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Modal Detail -->
<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title fw-bold">
                    <i class="fas fa-info-circle text-maroon me-2"></i>
                    Detail Peminjaman
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detailContent">
                <div class="text-center py-5">
                    <i class="fas fa-spinner fa-spin fa-2x text-maroon"></i>
                    <p class="mt-3">Memuat data...</p>
                </div>
            </div>
        </div>
    </div>
</div>
    <!-- JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function showDetail(mobilId) {
        const modal = new bootstrap.Modal(document.getElementById('detailModal'));
        const content = document.getElementById('detailContent');

        // Reset loading state
        content.innerHTML = `
            <div class="text-center py-5">
                <i class="fas fa-spinner fa-spin fa-2x text-maroon"></i>
                <p class="mt-3">Memuat data...</p>
            </div>
        `;

        // Tampilkan modal terlebih dahulu
        modal.show();

        // Lakukan fetch data detail
        fetch(`/mobil/${mobilId}/detail`)
            .then(response => response.json())
            .then(data => {
                content.innerHTML = `
                    <table class="table table-bordered">
                        <tr>
                            <th>Nama Peminjam</th>
                            <td>${data.peminjam}</td>
                        </tr>
                        <tr>
                            <th>Tanggal Pinjam</th>
                            <td>${data.tanggal_pinjam}</td>
                        </tr>
                        <tr>
                            <th>Tanggal Kembali</th>
                            <td>${data.tanggal_kembali}</td>
                        </tr>
                        <tr>
                            <th>Keperluan</th>
                            <td>${data.keperluan}</td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td><span class="badge bg-${data.status === 'dipinjam' ? 'danger' : 'success'}">${data.status}</span></td>
                        </tr>
                    </table>
                `;
            })
            .catch(err => {
                content.innerHTML = `
                    <div class="alert alert-danger">
                        Gagal memuat data. Silakan coba lagi.
                    </div>
                `;
                console.error('Error fetching detail:', err);
            });
    }
</script>
</body>
</html>
/* Add these responsive styles inside the existing <style> tag */

/* Tablet and Mobile Navigation */
@media (max-width: 991px) {
    .navbar-custom {
        height: auto;
        padding: 15px 0;
    }

    .container.d-flex.justify-content-center {
        flex-direction: column;
        height: auto;
        padding: 10px;
    }

    .navbar-nav {
        position: static;
        transform: none;
        flex-direction: column;
        width: 100%;
        gap: 10px;
    }

    .nav-right {
        position: static;
        transform: none;
        margin-top: 15px;
        text-align: center;
    }

    .nav-link {
        width: 100%;
        text-align: center;
        margin: 5px 0;
    }

    .btn-admin {
        width: 100%;
        justify-content: center;
    }
}

/* Tablet Styles */
@media (max-width: 768px) {
    .welcome-section h1 {
        font-size: 2rem;
    }

    .col-md-4 {
        flex: 0 0 50%;
        max-width: 50%;
    }

    .car-card {
        margin-bottom: 20px;
    }

    .car-image {
        height: 180px;
    }

    footer .col-md-4 {
        text-align: center;
    }
}

/* Mobile Styles */
@media (max-width: 576px) {
    .welcome-section h1 {
        font-size: 1.5rem;
    }

    .welcome-section p {
        font-size: 0.9rem;
    }

    .col-md-4 {
        flex: 0 0 100%;
        max-width: 100%;
    }

    .car-card {
        max-width: 100%;
    }

    .car-image {
        height: 200px;
    }

    .car-info h3 {
        font-size: 1.1rem;
    }

    .modal-dialog {
        margin: 0.5rem;
    }

    footer .card {
        margin: 0 10px;
    }

    footer .card-body {
        padding: 15px;
    }

    footer h5 {
        font-size: 1.1rem;
    }

    .container {
        padding: 15px;
    }
}

/* Ensure buttons stay readable on small screens */
@media (max-width: 400px) {
    .btn {
        padding: 8px 16px;
        font-size: 14px;
    }

    .table td, .table th {
        padding: 8px;
        font-size: 14px;
    }

    .modal-title {
        font-size: 1.1rem;
    }
}<?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/user/home.blade.php ENDPATH**/ ?>