<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengembalian Mobil</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #800020;      /* Maroon */
            --primary-light: #800020;      /* Tetap maroon */
            --primary-dark: #600018;       /* Darker Maroon */
            --accent-color: #FFD700;       /* Gold */
            --accent-light: #FFE55C;       /* Light Gold */
        }

        body { 
            background-color: #fff5f5; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .navbar-custom {
            background: var(--primary-color);
            padding: 0;
            position: relative;
            height: 80px;
        }

        .container.d-flex.justify-content-center {
            height: 100%;
            align-items: center;
        }

        .nav-link {
            color: white !important;
            padding: 18px 35px !important;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            border-radius: 30px !important;
            margin: 0 5px;
        }

        .nav-link:hover {
            transform: translateY(-2px);
            background: rgba(255,255,255,0.1);
        }

        .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 3px;
            background: #FFD700;
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }

        .nav-link:hover::after {
            width: 80%;
        }

        .nav-link.active {
            background: #FFD700;
            color: var(--primary-color) !important;
            transform: translateY(0);
            border-radius: 30px !important;
            box-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
        }

        .nav-link.active::after {
            display: none;
        }

        .nav-link i {
            margin-right: 8px;
            transition: transform 0.3s ease;
        }

        .nav-link:hover i {
            transform: scale(1.2);
        }

        .nav-right {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
        }

        .btn-admin {
            background: #FFD700;
            color: var(--primary-color);
            font-weight: 600;
            padding: 12px 30px;
            border: none;
            border-radius: 30px !important;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }

        .btn-admin:hover {
            background: #f8d000;
            color: var(--primary-color);
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.15);
        }

        .card {
            border: 2px solid var(--accent-color);
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(128, 0, 32, 0.1);
        }

        .card-header {
            background: var(--primary-color);  /* Maroon solid */
            color: white;
        }

        .form-control, .form-select {
            border-radius: 8px;
            border: 1px solid rgba(128, 0, 32, 0.2);
            padding: 0.8rem 1rem;
            transition: all 0.3s;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(128, 0, 32, 0.1);
        }

        .custom-file-upload {
            border: 2px dashed var(--accent-color);
            background: rgba(128, 0, 32, 0.05);
            transition: all 0.3s;
        }

        .custom-file-upload:hover {
            border-color: var(--primary-color);
            background: rgba(128, 0, 32, 0.1);
        }

        .custom-file-upload i {
            color: var(--primary-color);
        }

        .btn-submit {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-light));
            border: none;
            color: white;
            padding: 0.8rem 1.5rem;
            transition: all 0.3s;
        }

        .btn-submit:hover {
            background: linear-gradient(135deg, var(--primary-light), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(128, 0, 32, 0.3);
            color: white;
        }

        .preview-image {
            border: 2px solid var(--accent-color);
            border-radius: 8px;
        }

        .step-header {
            background: rgba(128, 0, 32, 0.05);
            border-left: 4px solid var(--primary-color);
            padding: 1rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
        }

        /* Tambahkan style untuk alert */
        .alert-container {
            animation: slideIn 0.5s ease-out;
        }
        @keyframes slideIn {
            0% {
                transform: translateX(100%);
            }
            100% {
                transform: translateX(0);
            }
        }
        .alert {
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            border: none;
            border-radius: 10px;
            padding: 1rem 1.5rem;
        }
        .alert-success {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-light));
            border-left: 4px solid var(--accent-color);
            color: white;
        }
        .btn-close {
            filter: brightness(0) invert(1);
        }

        .modal-content {
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(128, 0, 32, 0.1);
        }

        .modal-body {
            background: white !important;
            color: #333 !important;
            border-radius: 0 !important;
        }

        .modal-body .fas {
            color: var(--accent-color);
        }

        .modal-body .btn-primary {
            background: var(--accent-color);
            color: var(--primary-dark);
            font-weight: bold;
            border: none;
            padding: 0.8rem 2rem;
        }

        .modal-body .btn-primary:hover {
            background: var(--accent-light);
        }

        footer .card {
            background: rgba(128, 0, 32, 0.05);
            border: none;
        }

        footer a:hover {
            color: var(--primary-light) !important;
            text-decoration: underline !important;
        }

        .bg-maroon {
            background-color: var(--primary-color) !important;
        }
        .modal-header .btn-close {
            margin: -0.5rem -0.5rem -0.5rem auto;
        }
        .form-label {
            color: #333 !important;
        }
        .alert-info {
            border-left: 4px solid #0dcaf0;
        }
        .text-maroon {
            color: var(--primary-color) !important;
        }
        .border-maroon {
            border-color: var(--primary-color) !important;
        }
        .btn-maroon {
            background-color: var(--primary-color);
            color: white;
        }
        .btn-maroon:hover {
            background-color: var(--primary-dark);
            color: white;
        }
        .modal-header {
            background: var(--primary-color) !important;  /* Maroon solid */
            border-bottom: none;
            padding: 1.5rem 1.5rem 1rem;
        }
        .alert-light {
            background-color: #fff;
            border-left-width: 4px;
        }
        .form-label {
            margin-bottom: 0.5rem;
        }
        .modal-content {
            border: none;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
        .modal-title {
            font-size: 1.1rem;
            font-weight: 600;
        }
        .modal-body {
            padding: 1rem 1.5rem;
        }
        .modal-footer {
            border-top: none;
            padding: 1rem 1.5rem 1.5rem;
        }
        .form-label {
            font-weight: 500;
            color: #444;
        }
        .text-maroon {
            color: var(--primary-color) !important;
        }
        .btn:disabled {
            cursor: not-allowed;
            opacity: 0.7;
        }
        .btn-close-white {
            opacity: 1;
        }
        .text-muted {
            color: #666 !important;
        }
        .camera-container {
            max-width: 500px;
            margin: 0 auto;
        }

        #camera, #photo-preview {
            border-radius: 8px;
            margin-bottom: 1rem;
        }

        .btn-group {
            gap: 10px;
        }

        .btn-info {
            color: white;
        }

        .toast-notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            background: #E8F5E9;
            border: 1px solid #66BB6A;
            border-radius: 8px;
            padding: 16px 24px;
            display: flex;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            animation: slideIn 0.3s ease-out;
        }

        .toast-notification .icon {
            margin-right: 12px;
            color: #2E7D32;
            font-size: 24px;
        }

        .toast-notification .message {
            color: #1B5E20;
            font-size: 14px;
            font-weight: 500;
        }

        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-custom">
        <div class="container d-flex justify-content-center">
            <a class="nav-link <?php echo e(request()->routeIs('user.home') ? 'active' : ''); ?>" href="<?php echo e(route('user.home')); ?>">
                <i class="fas fa-home"></i> Home
            </a>
            <a class="nav-link <?php echo e(request()->routeIs('user.peminjaman') ? 'active' : ''); ?>" href="<?php echo e(route('user.peminjaman')); ?>">
                <i class="fas fa-car"></i> Peminjaman
            </a>
            <a class="nav-link <?php echo e(request()->routeIs('user.pengembalian') ? 'active' : ''); ?>" href="<?php echo e(route('user.pengembalian')); ?>">
                <i class="fas fa-undo"></i> Pengembalian
            </a>
        </div>
        <!-- <div class="nav-right">
            <a class="btn btn-admin" href="<?php echo e(route('admin.login')); ?>">
                <i class="fas fa-user"></i> Admin
            </a>
        </div> -->
    </nav>

    <?php if(session('success')): ?>
    <div class="alert-container" style="position: fixed; top: 20px; right: 20px; z-index: 1000;">
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
    <?php endif; ?>

    <div class="container py-4">
        <div class="card">
            <div class="card-header bg-maroon text-white">
                <h5 class="mb-0"><i class="fas fa-undo me-2"></i>Pengembalian Kendaraan</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="table-light">
                            <tr>
                                <th>Mobil</th>
                                <th>Peminjam</th>
                                <th>Tanggal Pinjam</th>
                                <th>Tanggal Kembali</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $peminjaman; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($p->mobil->nama); ?> (<?php echo e($p->mobil->plat_nomor); ?>)</td>
                                <td><?php echo e($p->nama); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($p->tanggal_pinjam)->format('d M Y')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($p->tanggal_kembali)->format('d M Y')); ?></td>
                                <td><span class="badge bg-warning"><?php echo e($p->status); ?></span></td>
                                <td>
                                    <button type="button" 
                                            class="btn btn-success btn-sm"
                                            onclick="showPengembalianModal('<?php echo e($p->id); ?>')">
                                        <i class="fas fa-check-circle me-1"></i>Kembalikan
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Pengembalian -->
    <div class="modal fade" id="modalPengembalian" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-white">
                        <i class="fas fa-car me-2"></i>Form Pengembalian Mobil
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form id="formPengembalian" action="<?php echo e(route('user.pengembalian.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="peminjaman_id" id="peminjaman_id">
                    
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="foto">Foto Kondisi Mobil</label>
                            <div class="camera-container mb-3">
                                <video id="camera" class="d-none w-100 mb-2" autoplay></video>
                                <canvas id="canvas" class="d-none"></canvas>
                                <img id="photo-preview" class="d-none w-100 mb-2" alt="Preview foto">
                                <input type="hidden" name="foto" id="foto-input">
                                <input type="file" id="file-input" class="d-none" accept="image/*">
                                
                                <div class="btn-group w-100 mb-2">
                                    <button type="button" class="btn btn-primary" id="start-camera">
                                        <i class="fas fa-camera"></i> Buka Kamera
                                    </button>
                                    <button type="button" class="btn btn-info" id="choose-file">
                                        <i class="fas fa-image"></i> Pilih dari Galeri
                                    </button>
                                </div>
                                
                                <div class="btn-group w-100">
                                    <button type="button" class="btn btn-success d-none" id="take-photo">
                                        <i class="fas fa-camera-retro"></i> Ambil Foto
                                    </button>
                                    <button type="button" class="btn btn-danger d-none" id="retake-photo">
                                        <i class="fas fa-redo"></i> Foto Ulang
                                    </button>
                                </div>
                            </div>
                            <?php $__errorArgs = ['foto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Catatan (Opsional)</label>
                            <textarea class="form-control" name="catatan" rows="3" placeholder="Tambahkan catatan jika ada..."></textarea>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                            Batal
                        </button>
                        <button type="submit" class="btn btn-success" id="btnKonfirmasi">
                            <i class="fas fa-check me-1"></i>Konfirmasi Pengembalian
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Template untuk notifikasi -->
    <div id="toastNotification" class="toast-notification" style="display: none;">
        <div class="icon">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="message" id="toastMessage"></div>
    </div>

    <footer class="mt-5 mb-4">
        <div class="container">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Kontak Kami</h5>
                            <div class="d-flex flex-column gap-2">
                                <div>
                                    <i class="fas fa-envelope me-2" style="color: var(--primary-color);"></i>
                                    <a href="mailto:disnakertrans@jogjaprov.go.id" class="text-decoration-none" style="color: var(--primary-color);">
                                        disnakertrans@jogjaprov.go.id
                                    </a>
                                </div>
                                <div>
                                    <i class="fas fa-phone me-2" style="color: var(--primary-color);"></i>
                                    <a href="tel:+62274512904" class="text-decoration-none" style="color: var(--primary-color);">
                                        (0274) 512904
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Lokasi</h5>
                            <div>
                                <i class="fas fa-map-marker-alt me-2" style="color: var(--primary-color);"></i>
                                <span style="color: var(--primary-dark);">
                                    Jl. Ring Road Utara Gg. Meguwo, Meguwo, Maguwoharjo, Kec. Depok, Kabupaten Sleman, Daerah Istimewa Yogyakarta 55282
                                </span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h5 class="mb-3">Jam Operasional</h5>
                            <div class="d-flex flex-column gap-2">
                                <div>
                                    <i class="fas fa-clock me-2" style="color: var(--primary-color);"></i>
                                    <span style="color: var(--primary-dark);">
                                        Senin - Kamis: 07:30 - 16:00
                                    </span>
                                </div>
                                <div>
                                    <i class="fas fa-clock me-2" style="color: var(--primary-color);"></i>
                                    <span style="color: var(--primary-dark);">
                                        Jumat: 07:30 - 14:30
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let camera_stream = null;
        let video = document.getElementById('camera');
        let canvas = document.getElementById('canvas');
        let photo = document.getElementById('photo-preview');
        let startButton = document.getElementById('start-camera');
        let takePhotoButton = document.getElementById('take-photo');
        let retakeButton = document.getElementById('retake-photo');
        let photoInput = document.getElementById('foto-input');
        let fileInput = document.getElementById('file-input');
        let chooseFileButton = document.getElementById('choose-file');

        // Event untuk memilih file dari galeri
        chooseFileButton.addEventListener('click', function() {
            fileInput.click();
        });

        fileInput.addEventListener('change', function(e) {
            if (e.target.files && e.target.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    // Tampilkan preview
                    photo.src = e.target.result;
                    photo.classList.remove('d-none');
                    
                    // Simpan base64
                    photoInput.value = e.target.result;
                    
                    // Update tampilan
                    video.classList.add('d-none');
                    takePhotoButton.classList.add('d-none');
                    retakeButton.classList.remove('d-none');
                    
                    // Hentikan kamera jika aktif
                    stopCamera();
                }
                
                reader.readAsDataURL(e.target.files[0]);
            }
        });

        startButton.addEventListener('click', async function() {
            try {
                camera_stream = await navigator.mediaDevices.getUserMedia({ 
                    video: { facingMode: 'environment' }, 
                    audio: false 
                });
                video.srcObject = camera_stream;
                video.classList.remove('d-none');
                startButton.classList.add('d-none');
                chooseFileButton.classList.add('d-none');
                takePhotoButton.classList.remove('d-none');
                photo.classList.add('d-none');
            } catch (err) {
                alert('Error mengakses kamera: ' + err.message);
            }
        });

        takePhotoButton.addEventListener('click', function() {
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            canvas.getContext('2d').drawImage(video, 0, 0);
            
            // Konversi ke base64
            let photo_data = canvas.toDataURL('image/jpeg');
            photo.src = photo_data;
            photoInput.value = photo_data;
            
            // Tampilkan preview dan tombol foto ulang
            photo.classList.remove('d-none');
            video.classList.add('d-none');
            takePhotoButton.classList.add('d-none');
            retakeButton.classList.remove('d-none');
            
            // Hentikan stream kamera
            stopCamera();
        });

        retakeButton.addEventListener('click', function() {
            // Reset tampilan
            startButton.classList.remove('d-none');
            chooseFileButton.classList.remove('d-none');
            retakeButton.classList.add('d-none');
            photo.classList.add('d-none');
            photoInput.value = '';
        });

        function stopCamera() {
            if (camera_stream) {
                camera_stream.getTracks().forEach(track => track.stop());
                camera_stream = null;
            }
        }

        // Hentikan kamera saat form disubmit
        document.querySelector('form').addEventListener('submit', function() {
            stopCamera();
        });

        // Hentikan kamera saat halaman ditutup
        window.addEventListener('beforeunload', function() {
            stopCamera();
        });

        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                const alert = document.querySelector('.alert');
                if (alert) {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }
            }, 5000);
        });

        function showNotification(message) {
            const toast = document.getElementById('toastNotification');
            const messageEl = document.getElementById('toastMessage');
            
            messageEl.textContent = message;
            toast.style.display = 'flex';
            
            // Hilangkan notifikasi setelah 3 detik
            setTimeout(() => {
                toast.style.display = 'none';
            }, 3000);
        }

        function showPengembalianModal(id) {
            // Reset form dan foto
            const formPengembalian = document.getElementById('formPengembalian');
            const photo = document.getElementById('photo-preview');
            const video = document.getElementById('camera');
            const startButton = document.getElementById('start-camera');
            const chooseFileButton = document.getElementById('choose-file');
            const takePhotoButton = document.getElementById('take-photo');
            const retakeButton = document.getElementById('retake-photo');
            const photoInput = document.getElementById('foto-input');
            
            // Reset form
            formPengembalian.reset();
            
            // Reset foto/kamera
            photo.classList.add('d-none');
            video.classList.add('d-none');
            startButton.classList.remove('d-none');
            chooseFileButton.classList.remove('d-none');
            takePhotoButton.classList.add('d-none');
            retakeButton.classList.add('d-none');
            photoInput.value = '';
            
            // Set peminjaman_id
            document.getElementById('peminjaman_id').value = id;
            
            // Hentikan kamera jika masih aktif
            stopCamera();
            
            // Show modal
            const modal = new bootstrap.Modal(document.getElementById('modalPengembalian'));
            modal.show();
        }

        document.addEventListener('DOMContentLoaded', function() {
            const formPengembalian = document.getElementById('formPengembalian');
            const btnKonfirmasi = document.getElementById('btnKonfirmasi');
            
            formPengembalian.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Validasi foto
                const fotoInput = document.getElementById('foto-input');
                if (!fotoInput.value) {
                    alert('Silakan ambil foto atau pilih dari galeri terlebih dahulu');
                    return;
                }
                
                // Disable tombol dan ubah text
                btnKonfirmasi.disabled = true;
                btnKonfirmasi.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Memproses...';
                
                // Submit form
                this.submit();
            });
        });

        // Tambahkan event listener untuk modal close
        document.getElementById('modalPengembalian').addEventListener('hidden.bs.modal', function () {
            stopCamera();
            const btnKonfirmasi = document.getElementById('btnKonfirmasi');
            btnKonfirmasi.disabled = false;
            btnKonfirmasi.innerHTML = '<i class="fas fa-check me-1"></i>Konfirmasi Pengembalian';
        });
    </script>
</body>
</html>

/* Add these responsive styles inside the existing <style> tag */

/* Tablet and Mobile Navigation */
@media (max-width: 991px) {
    .navbar-custom {
        height: auto;
        padding: 15px 0;
    }

    .container.d-flex.justify-content-center {
        flex-direction: column;
        height: auto;
        padding: 10px;
    }

    .nav-link {
        width: 100%;
        text-align: center;
        margin: 5px 0;
    }

    .nav-right {
        position: static;
        transform: none;
        margin-top: 15px;
        text-align: center;
    }

    .btn-admin {
        width: 100%;
        justify-content: center;
    }
}

/* Tablet Styles */
@media (max-width: 768px) {
    .card-header h3 {
        font-size: 1.5rem;
    }

    .camera-container {
        width: 100%;
        max-width: 100%;
    }

    #camera, #photo-preview {
        width: 100%;
        height: auto;
    }

    .btn-group {
        flex-direction: column;
        width: 100%;
    }

    .btn-group .btn {
        margin: 5px 0;
        width: 100%;
    }

    .table td {
        font-size: 14px;
    }

    .modal-dialog {
        margin: 10px;
    }
}

/* Mobile Styles */
@media (max-width: 576px) {
    .container {
        padding: 10px;
    }

    .card {
        margin: 10px 0;
        border-radius: 10px;
    }

    .card-body {
        padding: 15px;
    }

    .btn {
        padding: 8px 16px;
        font-size: 14px;
    }

    .table-responsive {
        margin: 0 -15px;
    }

    .table td {
        padding: 10px;
    }

    .modal-content {
        border-radius: 10px;
    }

    .toast-notification {
        width: 90%;
        left: 50%;
        transform: translateX(-50%);
        bottom: 20px;
    }

    #camera-container {
        margin: 0 -15px;
    }

    .camera-options {
        flex-direction: column;
        gap: 10px;
    }

    .camera-options .btn {
        width: 100%;
    }
}

/* Extra Small Devices */
@media (max-width: 400px) {
    .card-header {
        padding: 15px;
    }

    .form-label {
        font-size: 14px;
    }

    .alert {
        padding: 10px;
        font-size: 14px;
    }

    .modal-header {
        padding: 15px;
    }

    .modal-body {
        padding: 15px;
    }

    .modal-footer {
        padding: 10px 15px;
    }
}<?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/user/pengembalian.blade.php ENDPATH**/ ?>